/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2015 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */
/*eslint-disable no-undef, no-unused-vars */

var PreviewGlobal = require("../common/PreviewGlobal");

PreviewGlobal.themeManager = (function () {
    "use strict";

    PreviewGlobal.window.$body = $("body");
    
    /**
     * Convert the Color object to string in hexadecimal format;
     */
    function toHex(color) {
        
        function computeValue(value) {
            var computedValue = Math.floor(value).toString(16);
            return ("0" + computedValue).slice(-2);
        }
    
        return computeValue(color.red) + computeValue(color.green) + computeValue(color.blue);
    }
            
    /**
     * Update the theme with the AppSkinInfo retrieved from the host product.
     */
    function updateThemeWithAppSkinInfo(appSkinInfo) {
        var rgbBgColor = appSkinInfo.panelBackgroundColor.color,
            cssBgColor = "#" + toHex(rgbBgColor);
       
        $body.removeClass();        
        if (process.platform.substr(0, 3) === "win") {
            $body.addClass("windows");
        }
        
        switch (rgbBgColor.red) {
        case 50:
        case 52:
            $body.addClass("darker");
            break;
        case 83:
            $body.addClass("dark");
            break;
        case 184:
            $body.addClass("light");
            break;
        case 214:
        case 240:
            $body.addClass("lighter");
            break;
        default:
            // unrecognized theme
            $body.addClass("dark");
            break;
        }

        $body.css({"background-color": cssBgColor});
    }
    
    function onAppThemeColorChanged() {
        var skinInfo = PreviewGlobal.window.JSON.parse(PreviewGlobal.window.__adobe_cep__.getHostEnvironment()).appSkinInfo;
        updateThemeWithAppSkinInfo(skinInfo);
    }

    function init() {
        updateThemeWithAppSkinInfo(PreviewGlobal.csInterface.hostEnvironment.appSkinInfo);
        PreviewGlobal.csInterface.addEventListener(CSInterface.THEME_COLOR_CHANGED_EVENT, onAppThemeColorChanged);
    }
    
    return {
        init: init
    };
    
}());
